#include "pch.h"

#include "Mem.hpp"
#include "Common.hpp"
#include "CfgParse.hpp"
#include "Misc.hpp"
#include "Links.h"
#include "Areas.h"
#include "Msg.hpp"
#include "Tic.hpp"
#include "crc32.hpp"
#include "Temp.hpp"
#include "File.h"

#include "CfgLexems.hpp"
#include "WELexems.h"

#include "MsgAttrs.h"

#include "Adrenalin.h"

/*
 * Implementation of CAdrenalin::ParseAppCfg()
 *
 */

#define RESET_FLAGS	fWaitingUseAKA          = false; \
					fWaitingForDefaultGroup = false;

void CAdrenalin::ParseAppCfg() {
    vector<SCfgFile>	vCfgFiles;
    
    int         i, j, k, nLine;
    const TCHAR* szAppCfgName = _T("Adrenalin.cfg");
    TCHAR       szAppCfgFullName[MAX_PATH];

    // log files names
    TCHAR       szLogFileName[MAX_PATH];
    szLogFileName[0] = TEXT('\0');

    requestsLogFileName[0] = TEXT('\0');

    TCHAR       szFileName[MAX_PATH];
    SFTNAddress NewAKAAddr;
    
    bool        fWaitingUseAKA;
    bool        fWaitingForDefaultGroup;

    bool        fIncludeFound;
    CCfgParser  cfgParser;

    lstrcpy( szAppCfgFullName, m_szStartupPath );
    lstrcat( szAppCfgFullName, szAppCfgName );

    //
    // prepare global values
    //
    
    g_vars.m_addrMain.Domain[0]    = _T('\0');
    g_vars.m_szSysOp[0]            = _T('\0');
    g_vars.m_szInboundPath[0]      = _T('\0');
    g_vars.m_szOutboundPath[0]     = _T('\0');
    g_vars.m_szBinkOutboundPath[0] = _T('\0');
    g_vars.m_szNetmailPath[0]      = _T('\0');

    g_vars.m_szBadTicsPath[0]       = TEXT('\0');
    g_vars.m_szNewTicsPath[0]       = TEXT('\0');
    g_vars.m_szProcessedTicsPath[0] = TEXT('\0');

    g_vars.m_szAutoCreatedPath[0]  = _T('\0');
    g_vars.m_szLongDescPrefix[0]   = _T('\0');
    g_vars.m_szAutoDescFileName[0] = _T('\0');
    m_szLngFileName[0]             = _T('\0');

    g_vars.m_szFilelistFileName[0] = TEXT('\0');
    
    g_vars.m_szFixFlagName[0]   = _T('\0');
    g_vars.m_szTossFlagName[0]  = _T('\0');
    g_vars.m_szHatchFlagName[0] = _T('\0');

    g_vars.m_nForwardExpirationTime = 0;

    g_vars.m_nMessageKBytesLimit = 0;
    g_vars.m_nMessageLinesLimit  = 0;

    // message attributes and flags are not set
    g_vars.m_nReplyMessageAttrs = 0;
    g_vars.m_nReplyMessageFlags = 0;

    // no warn by default
    g_vars.m_nWarnSysopByMail = 0;

	// notify about everything by default
	g_vars.m_nNoMailNotify = 0;

	// no max tic age
	g_vars.maxTicAge = -1;

    RESET_FLAGS;
    
    m_iErrorCode = ERROR_NONE;
    nLine = 0;

    // add first item AppCfgFullName into config names list
    {
	    SCfgFile	cfgFile;
	    lstrcpy( cfgFile.m_szName, szAppCfgFullName );
	    cfgFile.m_iSkipLines = 0;
	    vCfgFiles.push_back( cfgFile );
    }

    while (!vCfgFiles.empty() && m_iErrorCode == ERROR_NONE) {
        fIncludeFound = false;
        if (cfgParser.Open( vCfgFiles.back().m_szName )) {
		i = 0;
		// skip desired number of lines
		{
			SCfgFile	cfgFile = vCfgFiles.back();
			while (!cfgParser.Eof() && !cfgParser.Failed() && cfgParser.GetLine() < cfgFile.m_iSkipLines)
				cfgParser.ReadLine();
			nLine = cfgFile.m_iSkipLines;
		}
		// read lines
            while (m_iErrorCode == ERROR_NONE && !cfgParser.Eof() && !fIncludeFound) {
                cfgParser.ReadLine();
                if (!cfgParser.Failed()) {
                    nLine++;
                    if (cfgParser.Count() == 0)
                        continue;
                    switch (getCfgLexemID( cfgParser[0] )) {
                        /*********
                          Address
                         *********/
                        case CFG_LEXEM_ADDRESS: {
				RESET_FLAGS;
                            if (cfgParser.Count() != 2) {
				    cfgParser.LogError( TEXT("Number error") );
				    m_iErrorCode = ERROR_NUMBER;
				    break;
                            }
                            if (g_vars.m_addrMain.Domain[0] != TEXT('\0')) {
				    cfgParser.LogError( TEXT("Duplicate error") );
				    m_iErrorCode = ERROR_DUPLICATE;
				    break;
                            }
                            if (!ParseFTNAddress( cfgParser[1], g_vars.m_addrMain )) {
				    cfgParser.LogError( TEXT("Syntax error") );
				    m_iErrorCode = ERROR_SYNTAX;
				    break;
                            }
                            if (g_vars.m_addrMain.Domain[0] == TEXT('\0'))
				lstrcpy( g_vars.m_addrMain.Domain, TEXT("Fidonet") );
                            break;
                        }
                        /*****
                          AKA
                         *****/
                        case CFG_LEXEM_AKA: {
				RESET_FLAGS;
                            // if main address undefined, error occured
                            if (g_vars.m_addrMain.Domain[0] == TEXT('\0')) {
				    cfgParser.LogError( TEXT("Forward error") );
				    m_iErrorCode = ERROR_FORWARD_DEF;
				    break;
                            }
                            if (cfgParser.Count() != 2) {
                                cfgParser.LogError( TEXT("Number error") );
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (!ParseLinkAddr( cfgParser[1], NewAKAAddr )) {
                                cfgParser.LogError( TEXT("Syntax error") );
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            // check if already defined;
                            if (AddrCmp( g_vars.m_addrMain, NewAKAAddr ) == 0) {
				    cfgParser.LogError( TEXT("Duplicate error") );
				    m_iErrorCode = ERROR_DUPLICATE;
				    break;
                            }

			    vector<SFTNAddress>::iterator	it = g_vars.m_vAKAAddr.begin();
			    while (it != g_vars.m_vAKAAddr.end()) {
                                if (AddrCmp( (*it), NewAKAAddr ) == 0)
                                    break;
				it++;
                            }
                            if (it != g_vars.m_vAKAAddr.end()) {
                                cfgParser.LogError( TEXT("Duplicate error") );
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
			    g_vars.m_vAKAAddr.push_back( NewAKAAddr );
                            break;
                        }
                        /*******
                          SysOp
                         *******/
                        case CFG_LEXEM_SYSOP: {
				RESET_FLAGS;
                            if (cfgParser.Count() == 1) {
                                cfgParser.LogError( TEXT("Number error") );
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_szSysOp[0] != _T('\0')) {
                                cfgParser.LogError( TEXT("Duplicate error") );
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            lstrcpyn( g_vars.m_szSysOp, cfgParser[1], 36 );
                            k = lstrlen(g_vars.m_szSysOp); // copy to pos k
                            j = 35 - k; // how many symbols we can still copy
                            for (i = 2; i < cfgParser.Count() && j > 1; i++) {
                                lstrcpy( g_vars.m_szSysOp + k, " " );
                                k++;
                                lstrcpyn( g_vars.m_szSysOp + k, cfgParser[i], j );
                                k = lstrlen(g_vars.m_szSysOp);
                                j = 35 - k;       
                            }
                            break;
                        }
                        /*********
                          Inbound
                         *********/
                        case CFG_LEXEM_INBOUND:  {
				RESET_FLAGS;
                            if (cfgParser.Count() != 2) {
                                cfgParser.LogError( TEXT("Number error") );
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_szInboundPath[0] != TEXT('\0')) {
                                cfgParser.LogError( TEXT("Duplicate error") );
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            lstrcpy( g_vars.m_szInboundPath, cfgParser[1] );

                            if (!CorrectPath( g_vars.m_szInboundPath )) {
                                cfgParser.LogError( TEXT("Syntax error") );
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            if (g_vars.m_szInboundPath[lstrlen(g_vars.m_szInboundPath)-1] != PATH_SEPARATOR)
                                lstrcat( g_vars.m_szInboundPath, PATH_SEPARATOR_STR );
                            break;
                        }
                        /**********
                          Outbound
                         **********/
                        case CFG_LEXEM_OUTBOUND: {
				RESET_FLAGS;
                            if (cfgParser.Count() != 2) {
                                cfgParser.LogError( TEXT("Number error") );
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_szOutboundPath[0] != TEXT('\0')) {
                                cfgParser.LogError( TEXT("Duplicate error") );
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            lstrcpy( g_vars.m_szOutboundPath, cfgParser[1] );
                            if (!CorrectPath( g_vars.m_szOutboundPath )) {
                                cfgParser.LogError( TEXT("Syntax error") );
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            if (g_vars.m_szOutboundPath[lstrlen(g_vars.m_szOutboundPath)-1]
                                != PATH_SEPARATOR)
                                lstrcat( g_vars.m_szOutboundPath, PATH_SEPARATOR_STR );
                            break;
                        }
                        /**************
                          BinkOutbound
                         **************/
                        case CFG_LEXEM_BINK_OUTBOUND: {
							RESET_FLAGS;
                            if (cfgParser.Count() != 2) {
								cfgParser.LogError( TEXT("Number error") );
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_szBinkOutboundPath[0] != TEXT('\0')) {
								cfgParser.LogError( TEXT("Duplicate error") );
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            lstrcpy( g_vars.m_szBinkOutboundPath, cfgParser[1] );
                            if (!CorrectPath( g_vars.m_szBinkOutboundPath )) {
								cfgParser.LogError( TEXT("Syntax error") );
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            if (g_vars.m_szBinkOutboundPath[lstrlen(g_vars.m_szBinkOutboundPath)-1] != PATH_SEPARATOR)
                                lstrcat( g_vars.m_szBinkOutboundPath, PATH_SEPARATOR_STR );
                            break;
                        }
                        /***********
                          FileBoxes
                         ***********/
                        case CFG_LEXEM_FILE_BOXES: {
							RESET_FLAGS;
                            if (cfgParser.Count() != 2) {
								cfgParser.LogError( TEXT("Number error") );
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
							CommonDataPtr	commonData = CCommonData::getInstance();
							if (commonData->getFileBoxesPath().size() > 0) {
								cfgParser.LogError( TEXT("Duplicate file boxes definition error") );
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
							// path allowed is MAX_PATH-1, + two possible " around path
							if (lstrlen( cfgParser[1] ) >= MAX_PATH + 1) {
								cfgParser.LogError( TEXT("Too long path") );
								m_iErrorCode = ERROR_SYNTAX;
								break;
							}

							TCHAR	path[MAX_PATH+2];
							lstrcpy( path, cfgParser[1] );

                            if (!CorrectPath( path )) {
								cfgParser.LogError( TEXT("Syntax error") );
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
							if (path[lstrlen(path) - 1] != PATH_SEPARATOR) {
                                lstrcat( path, PATH_SEPARATOR_STR );
							}

							commonData->setFileBoxesPath( path );
							commonData->setLongFileBoxes( false );

							MakeDirStructure( path, 0 );

                            break;
                        }
                        /***************
                          LongFileBoxes
                         ***************/
                        case CFG_LEXEM_LONG_FILE_BOXES: {
							RESET_FLAGS;
                            if (cfgParser.Count() != 2) {
								cfgParser.LogError( TEXT("Number error") );
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
							CommonDataPtr	commonData = CCommonData::getInstance();
							if (commonData->getFileBoxesPath().size() > 0) {
								cfgParser.LogError( TEXT("Duplicate file boxes definition error") );
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
							// path allowed is MAX_PATH-1, + two possible " around path
							if (lstrlen( cfgParser[1] ) >= MAX_PATH + 1) {
								cfgParser.LogError( TEXT("Too long path") );
								m_iErrorCode = ERROR_SYNTAX;
								break;
							}

							TCHAR	path[MAX_PATH+2];
							lstrcpy( path, cfgParser[1] );

                            if (!CorrectPath( path )) {
								cfgParser.LogError( TEXT("Syntax error") );
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
							if (path[lstrlen(path) - 1] != PATH_SEPARATOR) {
                                lstrcat( path, PATH_SEPARATOR_STR );
							}

							commonData->setFileBoxesPath( path );
							commonData->setLongFileBoxes( true );

							MakeDirStructure( path, 0 );

                            break;
                        }
                        /*********
                          Netmail
                         *********/
                        case CFG_LEXEM_NETMAIL: {
				RESET_FLAGS;
                            if (cfgParser.Count() != 2) {
				cfgParser.LogError( TEXT("Number error") );
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_szNetmailPath[0] != TEXT('\0')) {
				cfgParser.LogError( TEXT("Duplicate error") );
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            lstrcpy( g_vars.m_szNetmailPath, cfgParser[1] );
                            if (!CorrectPath( g_vars.m_szNetmailPath )) {
				cfgParser.LogError( TEXT("Syntax error") );
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            if (g_vars.m_szNetmailPath[lstrlen(g_vars.m_szNetmailPath)-1]
                                != PATH_SEPARATOR)
                                lstrcat( g_vars.m_szNetmailPath, PATH_SEPARATOR_STR );
                            break;
                        }
                        /*********
                          BadTics
                         *********/
                        case CFG_LEXEM_BAD_TICS: {
				RESET_FLAGS;
                            if (cfgParser.Count() != 2) {
				cfgParser.LogError( TEXT("Number error") );
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_szBadTicsPath[0] != TEXT('\0')) {
				cfgParser.LogError( TEXT("Duplicate error") );
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            lstrcpy( g_vars.m_szBadTicsPath, cfgParser[1] );
                            if (!CorrectPath( g_vars.m_szBadTicsPath )) {
				cfgParser.LogError( TEXT("Syntax error") );
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            if (g_vars.m_szBadTicsPath[lstrlen(g_vars.m_szBadTicsPath)-1]
                                != PATH_SEPARATOR)
                                lstrcat( g_vars.m_szBadTicsPath, PATH_SEPARATOR_STR );
                            break;
                        }
                        /*********
                          NewTics
                         *********/
                        case CFG_LEXEM_NEW_TICS: {
				RESET_FLAGS;
                            if (cfgParser.Count() != 2) {
				cfgParser.LogError( TEXT("Number error") );
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_szNewTicsPath[0] != TEXT('\0')) {
				cfgParser.LogError( TEXT("Duplicate error") );
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            lstrcpy( g_vars.m_szNewTicsPath, cfgParser[1] );
                            if (!CorrectPath( g_vars.m_szNewTicsPath )) {
				cfgParser.LogError( TEXT("Syntax error") );
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            if (g_vars.m_szNewTicsPath[lstrlen(g_vars.m_szNewTicsPath)-1]
                                != PATH_SEPARATOR)
                                lstrcat( g_vars.m_szNewTicsPath, PATH_SEPARATOR_STR );
                            break;
                        }
                        /***************
                          ProcessedTics
                         ***************/
                        case CFG_LEXEM_PROCESSED_TICS: {
				RESET_FLAGS;
                            if (cfgParser.Count() != 2) {
				cfgParser.LogError( TEXT("Number error") );
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_szProcessedTicsPath[0] != TEXT('\0')) {
				cfgParser.LogError( TEXT("Duplicate error") );
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            lstrcpy( g_vars.m_szProcessedTicsPath, cfgParser[1] );
                            if (!CorrectPath( g_vars.m_szProcessedTicsPath )) {
				cfgParser.LogError( TEXT("Syntax error") );
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            if (g_vars.m_szProcessedTicsPath[lstrlen(g_vars.m_szProcessedTicsPath)-1]
                                != PATH_SEPARATOR)
                                lstrcat( g_vars.m_szProcessedTicsPath, PATH_SEPARATOR_STR );
                            break;
                        }
                        /*************
                          AutoCreated
                         *************/
                        case CFG_LEXEM_AUTOCREATED: {
							fWaitingUseAKA          = false;
							fWaitingForDefaultGroup = false;
							if (cfgParser.Count() != 2) {
								g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
								m_iErrorCode = ERROR_NUMBER;
								break;
							}
							if (g_vars.m_szAutoCreatedPath[0] != _T('\0')) {
								g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
								m_iErrorCode = ERROR_DUPLICATE;
								break;
							}
							lstrcpy( g_vars.m_szAutoCreatedPath, cfgParser[1] );
							if (g_vars.m_szAutoCreatedPath[0] == TEXT('"')) {
								RemoveBoundaryQuotes( g_vars.m_szAutoCreatedPath );
							}
							if (g_vars.m_szAutoCreatedPath[lstrlen(g_vars.m_szAutoCreatedPath)-1] != _T('\\')) {
								lstrcat( g_vars.m_szAutoCreatedPath, _T("\\"));
							}
							break;
                        }
                        /****************
                          LongDescPrefix
                         ****************/
                        case CFG_LEXEM_LONG_DESC_PREFIX: {
                            fWaitingUseAKA          = false;
                            fWaitingForDefaultGroup = false;
                            if (cfgParser.Count() != 2) {
				g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            i = lstrlen(cfgParser[1]);
                            if (i > LONG_DESC_PREFIX_SIZE)
                            {
				g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            if (g_vars.m_szLongDescPrefix[0] != _T('\0')) {
				g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            lstrcpy( g_vars.m_szLongDescPrefix, cfgParser[1] );
                            if (*g_vars.m_szLongDescPrefix == _T('"'))
                                RemoveBoundaryQuotes( g_vars.m_szLongDescPrefix );
                            if (*g_vars.m_szLongDescPrefix == _T('\0')) {
				g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            break;
                        }
                        /*************
                          LogFile
                         *************/
                        case CFG_LEXEM_LOG_FILE: {
			                RESET_FLAGS;
                            if (cfgParser.Count() != 2) {
				                cfgParser.LogError( TEXT("Number error") );
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (!IsEmptyStr(szLogFileName)) {
				                cfgParser.LogError( TEXT("Duplicate error") );
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            lstrcpy( szLogFileName, cfgParser[1] );
                            if (!CorrectPath( szLogFileName )) {
				                cfgParser.LogError( TEXT("Syntax error") );
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            break;
                        }
			            /*****************
			              RequestsLogFile
			             *****************/
                        case CFG_LEXEM_REQUESTS_LOG_FILE: {
			                RESET_FLAGS;
                            if (cfgParser.Count() != 2) {
				                cfgParser.LogError( TEXT("Number error") );
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (!IsEmptyStr(requestsLogFileName)) {
				                cfgParser.LogError( TEXT("Duplicate error") );
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            lstrcpy( requestsLogFileName, cfgParser[1] );
                            if (!CorrectPath( requestsLogFileName )) {
				                cfgParser.LogError( TEXT("Syntax error") );
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            break;
                        }
                        /**************
                          AutoDescFile
                         **************/
                        case CFG_LEXEM_AUTO_DESC_FILE: {
                            RESET_FLAGS;
                            if (cfgParser.Count() != 2) {
				            g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_szAutoDescFileName[0] != _T('\0')) {
				g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            lstrcpy( g_vars.m_szAutoDescFileName, cfgParser[1] );
                            if (!CorrectPath( g_vars.m_szAutoDescFileName )) {
				g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            break;
                        }
                        /*********
                          LngFile
                         *********/
                        case CFG_LEXEM_LNG_FILE: {
                            fWaitingUseAKA          = false;
                            fWaitingForDefaultGroup = false;
                            if (cfgParser.Count() != 2) {
				g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (m_szLngFileName[0] != _T('\0')) {
				g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            lstrcpy( m_szLngFileName, cfgParser[1] );
                            if (!CorrectPath( m_szLngFileName )) {
				g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            break;
                        }
			/**********
			  Filelist
			 **********/
			case CFG_LEXEM_FILE_LIST:
				{
					RESET_FLAGS;
					// check number of arguments
					if (cfgParser.Count() != 2) {
						cfgParser.LogError( TEXT("Number error") );
						m_iErrorCode = ERROR_NUMBER;
						break;
					}
					// check duplicate
					if (g_vars.m_szFilelistFileName[0] != TEXT('\0')) {
						cfgParser.LogError( TEXT("Duplicate error") );
						m_iErrorCode = ERROR_DUPLICATE;
						break;
					}
					// keep file name
					lstrcpy( g_vars.m_szFilelistFileName, cfgParser[1] );
					if (!CorrectName( g_vars.m_szFilelistFileName )) {
						cfgParser.LogError( TEXT("Syntax error") );
						m_iErrorCode = ERROR_SYNTAX;
						break;
					}
				}
				break;
			/****************
			  FilelistFormat
			 ****************/
			case CFG_LEXEM_FILE_LIST_FORMAT:
				{
					RESET_FLAGS;
					// check number of arguments
					if (cfgParser.Count() != 2) {
						cfgParser.LogError( TEXT("Number error") );
						m_iErrorCode = ERROR_NUMBER;
						break;
					}
					// check duplicate
					if (g_vars.m_fileListFormat.getFormat().length() > 0) {
						cfgParser.LogError( TEXT("Duplicate error") );
						m_iErrorCode = ERROR_DUPLICATE;
						break;
					}
					// remove quotes around format
					LPTSTR	buffer = new TCHAR[ lstrlen(cfgParser[1]) + 1];
					lstrcpy( buffer, cfgParser[1] );
					RemoveBoundaryQuotes( buffer );
					// remember format
					g_vars.m_fileListFormat.setFormat( buffer );
					delete [] buffer;
				}
				break;
                        /*********
                          Flags
                         *********/
                        case CFG_LEXEM_CREATE_FLAG_AFTER: {
				RESET_FLAGS;
                            if (cfgParser.Count() != 3) {
				g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (lstrcmpi( cfgParser[1], _T("Fix") ) == 0) {
                                if (*g_vars.m_szFixFlagName != _T('\0')) {
				    g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                    m_iErrorCode = ERROR_DUPLICATE;
                                    break;
                                }
                                lstrcpy( g_vars.m_szFixFlagName, cfgParser[2] );
                                if (!CorrectPath( g_vars.m_szFixFlagName )) {
				    g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                    m_iErrorCode = ERROR_SYNTAX;
                                    break;
                                }
                            }
                            else if (lstrcmpi( cfgParser[1], _T("Toss") ) == 0) {
                                if (*g_vars.m_szTossFlagName != _T('\0')) {
				    g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                    m_iErrorCode = ERROR_DUPLICATE;
                                    break;
                                }
                                lstrcpy( g_vars.m_szTossFlagName, cfgParser[2] );
                                if (!CorrectPath( g_vars.m_szTossFlagName )) {
				    g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                    m_iErrorCode = ERROR_SYNTAX;
                                    break;
                                }
                            }
                            else if (lstrcmpi( cfgParser[1], _T("Hatch") ) == 0) {
                                if (*g_vars.m_szHatchFlagName != _T('\0')) {
				    g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                    m_iErrorCode = ERROR_DUPLICATE;
                                    break;
                                }
                                lstrcpy( g_vars.m_szHatchFlagName, cfgParser[2] );
                                if (!CorrectPath( g_vars.m_szHatchFlagName )) {
				    g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                    m_iErrorCode = ERROR_SYNTAX;
                                    break;
                                }
                            }
                            else if (lstrcmpi( cfgParser[1], _T("All") ) == 0) {
                                if (*g_vars.m_szFixFlagName != _T('\0')  ||
                                    *g_vars.m_szTossFlagName != _T('\0') ||
                                    *g_vars.m_szHatchFlagName != _T('\0'))
                                {
				    g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                    m_iErrorCode = ERROR_DUPLICATE;
                                    break;
                                }
                                lstrcpy( g_vars.m_szFixFlagName, cfgParser[2] );
                                if (!CorrectPath( g_vars.m_szFixFlagName )) {
				    g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                    m_iErrorCode = ERROR_SYNTAX;
                                    break;
                                }
                                lstrcpy( g_vars.m_szTossFlagName, cfgParser[2] );
                                if (!CorrectPath( g_vars.m_szTossFlagName )) {
				    g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                    m_iErrorCode = ERROR_SYNTAX;
                                    break;
                                }
                                lstrcpy( g_vars.m_szHatchFlagName, cfgParser[2] );
                                if (!CorrectPath( g_vars.m_szHatchFlagName )) {
				    g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                    m_iErrorCode = ERROR_SYNTAX;
                                    break;
                                }
                            }
                            break;
                        }
                        /***********
                          LongPaths
                         ***********/
                        case CFG_LEXEM_LONG_PATHS: {
                            fWaitingUseAKA          = false;
                            fWaitingForDefaultGroup = false;
                            if (cfgParser.Count() != 2) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_fLongPaths.Defined()) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            if (!ParseYesNo( cfgParser[1], g_vars.m_fLongPaths )) {
			        g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            break;
                        }
                        /******************
                          CheckDomainInBSO
                         ******************/
                        case CFG_LEXEM_CHECK_DOMAIN_IN_BSO: {
                            fWaitingUseAKA          = false;
                            fWaitingForDefaultGroup = false;
                            if (cfgParser.Count() != 2) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
			    if (g_vars.m_fCheckDomainInBSO.Defined()) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
			    }
                            if (!ParseYesNo( cfgParser[1], g_vars.m_fCheckDomainInBSO )) {
			        g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            break;
                        }
                        /****************
                          HandleReplaces
                         ****************/
                        case CFG_LEXEM_HANDLE_REPLACES: {
                            fWaitingUseAKA          = false;
                            fWaitingForDefaultGroup = false;
                            if (cfgParser.Count() != 2) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_fHandleReplaces.Defined()) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            if (!ParseYesNo( cfgParser[1], g_vars.m_fHandleReplaces )) {
			        g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            break;
                        }
                        /************
                          AllAKASeen
                         ************/
                        case CFG_LEXEM_ALL_AKA_SEEN: {
                            fWaitingUseAKA          = false;
                            fWaitingForDefaultGroup = false;
                            if (cfgParser.Count() != 2) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_fAllAKASeen.Defined()) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            if (!ParseYesNo( cfgParser[1], g_vars.m_fAllAKASeen )) {
			        g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            break;
                        }
                        /*******************
                          KillProcessedMail
                         *******************/
                        case CFG_LEXEM_KILL_PROCESSED_MAIL: {
                            fWaitingUseAKA          = false;
                            fWaitingForDefaultGroup = false;
                            if (cfgParser.Count() != 2) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_fKillProcessedMail.Defined()) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            if (!ParseYesNo( cfgParser[1], g_vars.m_fKillProcessedMail )) {
			        g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            break;
                        }
                        /**************
                          ShowMustGoOn
                         **************/
                        case CFG_LEXEM_SHOW_MUST_GO_ON: {
                            fWaitingUseAKA          = false;
                            fWaitingForDefaultGroup = false;
                            if (cfgParser.Count() != 2) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_fShowMustGoOn.Defined()) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            if (!ParseYesNo( cfgParser[1], g_vars.m_fShowMustGoOn )) {
			        g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            break;
                        }
                        /*************
                          LogMsgNames
                         *************/
                        case CFG_LEXEM_LOG_MSG_NAMES: {
                            fWaitingUseAKA          = false;
                            fWaitingForDefaultGroup = false;
                            if (cfgParser.Count() != 2) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_fLogMsgNames.Defined()) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            if (!ParseYesNo( cfgParser[1], g_vars.m_fLogMsgNames )) {
			        g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            break;
                        }

                        /********************
                          ConcatDescriptions
                         ********************/
                        case CFG_LEXEM_CONCAT_DESCRIPTIONS: {
                            fWaitingUseAKA          = false;
                            fWaitingForDefaultGroup = false;
                            if (cfgParser.Count() != 2) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_flagConcatDescriptions.Defined()) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            if (!ParseYesNo( cfgParser[1], g_vars.m_flagConcatDescriptions )) {
			        g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            break;
                        }
                        
			/********************
                          HatchOriginAddress
                         ********************/
                        case CFG_LEXEM_HATCH_ORIGIN_ADDRESS: {
                            fWaitingUseAKA          = false;
                            fWaitingForDefaultGroup = false;
                            if (cfgParser.Count() != 2) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (g_vars.m_fHatchOriginMain.Defined()) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            if (lstrcmpi(cfgParser[1], _T("Main")) == 0) {
                                g_vars.m_fHatchOriginMain = true;
                            }
                            else if (lstrcmpi(cfgParser[1], _T("AKA")) == 0) {
                                g_vars.m_fHatchOriginMain = false;
                            }
                            else {
			        g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
                            }
                            break;
                        }
                        /*********
                          Aliases
                         *********/
                        case CFG_LEXEM_ALIASES: {
                            fWaitingUseAKA          = false;
                            fWaitingForDefaultGroup = false;
                            if (cfgParser.Count() == 1) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_NUMBER;
                                break;
                            }
                            if (!g_vars.m_vsAliases.empty()) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
                            // check dupe aliases
                            for (i = 1; i < cfgParser.Count(); i++) {
                                if (lstrcmpi( cfgParser[i], _T("Adrenalin") ) == 0)
                                    break;
                                for (j = 0; j < i; j++) {
                                    if (lstrcmpi( cfgParser[i], cfgParser[j] ) == 0)
                                        break;
                                }
                                if (j != i)
                                    break;
                            }
                            // loop was broken if i != cfgParser.Count()
                            if (i != cfgParser.Count()) {
			        g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_DUPLICATE;
                                break;
                            }
			    g_vars.m_vsAliases.push_back( _T("Adrenalin") );
                            for (i = 1; i < cfgParser.Count(); i++) {
                                g_vars.m_vsAliases.push_back( cfgParser[i] );
			    }
                            break;
                        }
                        /**************
                          MessageLimit
                         **************/
                        case CFG_LEXEM_MESSAGE_LIMIT: {
				// reset flags
				fWaitingUseAKA          = false;
				fWaitingForDefaultGroup = false;
				// check arguments count
				if (cfgParser.Count() != 3) {
					g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
					m_iErrorCode = ERROR_NUMBER;
					break;
				}
				int	nLimit;
				if (!StrToInt( cfgParser[2], nLimit ) || nLimit <= 0) {
					g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
					m_iErrorCode = ERROR_SYNTAX;
					break;
				}
				if (lstrcmpi( cfgParser[1], _T("KBytes") ) == 0) {
					if (g_vars.m_nMessageKBytesLimit > 0) {
						g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
						m_iErrorCode = ERROR_DUPLICATE;
					}
					else {
						// keep limit in bytes
						g_vars.m_nMessageKBytesLimit = nLimit << 10;
					}
					break;
				}
				if (lstrcmpi( cfgParser[1], _T("Lines") ) == 0) {
					if (g_vars.m_nMessageLinesLimit > 0) {
						g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
						m_iErrorCode = ERROR_DUPLICATE;
					}
					else {
						g_vars.m_nMessageLinesLimit = nLimit;
					}
					break;
				}
				// unrecognized option
			        g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                                m_iErrorCode = ERROR_SYNTAX;
                                break;
			}
                        /*
                         * FreeDiskSpaceLimit <DRIVE ROOT> <LIMIT IN KBYTES>
                         *
                         */
                        case CFG_LEXEM_FREE_DISK_SPACE_LIMIT: {
                        	fWaitingUseAKA          = false;
                        	fWaitingForDefaultGroup = false;
                        	if (cfgParser.Count() != 3) {
                            		g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                            		m_iErrorCode = ERROR_NUMBER;
                            		break;
                        	}
                        	// check for duplicates
				vector<SDiskLimit>::iterator	it;
				for (it = m_vDiskLimits.begin(); it != m_vDiskLimits.end(); it++) {
                        		if (lstrcmpi((*it).m_szRoot, cfgParser[1]) == 0)
                        			break;
				}
                        	if (it != m_vDiskLimits.end()) {
                            		g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                            		m_iErrorCode = ERROR_DUPLICATE;
                            		break;
                        	}
                        	DWORD	dwLimit;
                        	if (parseIntWithCommas( cfgParser[2], dwLimit )) {
                        		SDiskLimit	newLimit;
                        		lstrcpy( newLimit.m_szRoot, cfgParser[1] );
                        		newLimit.m_dwLimit = dwLimit;
					m_vDiskLimits.push_back( newLimit );
                        	}
                        	else {
					g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
					g_vars.m_log << _T("2nd argument is not a valid number\r\n");
					m_iErrorCode = ERROR_NUMBER;
                        	}
                        	break;
                        }
			/***********************
			  ForwardExpirationTime
			 ***********************/
			case CFG_LEXEM_FORWARD_EXPIRATION_TIME: {
				fWaitingUseAKA          = false;
				fWaitingForDefaultGroup = false;
				if (cfgParser.Count() != 2) {
					g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                            		g_vars.m_log << _T("Wrong number of arguments\r\n");
                            		m_iErrorCode = ERROR_NUMBER;
                            		break;
				}
				if (g_vars.m_nForwardExpirationTime != 0) { // already defined
                            		g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
					g_vars.m_log << _T("Already defined parameter\r\n");
                            		m_iErrorCode = ERROR_DUPLICATE;
                            		break;
				}
				g_vars.m_nForwardExpirationTime = _ttoi(cfgParser[1]);
				if (g_vars.m_nForwardExpirationTime == 0) {
					g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                            		g_vars.m_log << _T("Incorrect number\r\n");
                            		m_iErrorCode = ERROR_SYNTAX;
                            		break;
				}
				break;
			}
			/*******************
			  MaxTicAge <hours>
			 *******************/
			case CFG_LEXEM_MAX_TIC_AGE: {
				RESET_FLAGS;
				if (cfgParser.Count() != 2) {
					g_vars.m_log << TEXT("Error in file ") << vCfgFiles.back().m_szName << TEXT(" at line ") << nLine << TEXT_EOL;
                    g_vars.m_log << TEXT("Wrong number of arguments") << TEXT_EOL;
                    m_iErrorCode = ERROR_NUMBER;
                    break;
				}
				if (g_vars.maxTicAge >= 0) { // already defined
                    g_vars.m_log << TEXT("Error in file ") << vCfgFiles.back().m_szName << TEXT(" at line ") << nLine << TEXT_EOL;
					g_vars.m_log << TEXT("Already defined parameter") << TEXT_EOL;
                    m_iErrorCode = ERROR_DUPLICATE;
                    break;
				}
				g_vars.maxTicAge = _ttoi(cfgParser[1]);
				if (g_vars.maxTicAge <= 0) {
					g_vars.m_log << TEXT("Error in file ") << vCfgFiles.back().m_szName << TEXT(" at line ") << nLine << TEXT_EOL;
					g_vars.m_log << TEXT("Incorrect positive number") << TEXT_EOL;
                    m_iErrorCode = ERROR_SYNTAX;
                    break;
				}
				break;
			}
			/**********
			  FileFlag
			 **********/
			case CFG_LEXEM_FILE_FLAG:
				{					
					fWaitingUseAKA          = false;
					fWaitingForDefaultGroup = false;
					if (cfgParser.Count() < 3 || cfgParser.Count() > 4) {
						g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
						m_iErrorCode = ERROR_NUMBER;
						break;
					}
					TCHAR	szBuf[MAX_PATH];

					if (cfgParser.Count() == 4) {
						// flag
						lstrcpy( szBuf, cfgParser[1] );
						if (szBuf[0] == _T('"'))
							RemoveBoundaryQuotes( szBuf );
						AddStartupPath( szBuf );
						m_vsFileFlags.push_back( szBuf );

						// mask
						lstrcpy( szBuf, cfgParser[2] );
						if (szBuf[0] == _T('"'))
							RemoveBoundaryQuotes( szBuf );
						m_vsFileMasks.push_back( szBuf );

						// area
						m_vsFileAreas.push_back( cfgParser[3] );
					}
					else {
						// flag
						lstrcpy( szBuf, cfgParser[1] );
						if (szBuf[0] == _T('"'))
							RemoveBoundaryQuotes( szBuf );
						AddStartupPath( szBuf );
						m_vsCommonFileFlags.push_back( szBuf );

						// mask
						lstrcpy( szBuf, cfgParser[2] );
						if (szBuf[0] == _T('"'))
							RemoveBoundaryQuotes( szBuf );
						m_vsCommonFileMasks.push_back( szBuf );

						// used
						m_vbCommonFileFlagsUsed.push_back(false);
					}
				}
				break;
			/*****************
			  WarnSysopByMail
			 *****************/
			case CFG_LEXEM_WARN_SYSOP_BY_MAIL:
				{
					RESET_FLAGS;
					// check for duplicate
					if (g_vars.m_nWarnSysopByMail != 0) {
						cfgParser.LogError( TEXT("Duplicate error") );
						m_iErrorCode = ERROR_DUPLICATE;
						break;
					}
					// possible arguments are:
					// Warnings
					// Errors
					// Warnings Errors
					// (in any order)
					if (cfgParser.Count() == 1 || cfgParser.Count() > 3) {
						cfgParser.LogError( TEXT("Number error") );
						m_iErrorCode = ERROR_NUMBER;
						break;
					}
					for (i = 1; i < cfgParser.Count(); i++) {
						// check for "Warnings"
						if (lstrcmpi( cfgParser[i], "Warnings" ) == 0) {
							// check if prevously set
							if ((g_vars.m_nWarnSysopByMail & WARN_SYSOP_ABOUT_WARNINGS) != 0) {
								cfgParser.LogError( TEXT("Duplicate error") );
								m_iErrorCode = ERROR_DUPLICATE;
								break;
							}
							g_vars.m_nWarnSysopByMail |= WARN_SYSOP_ABOUT_WARNINGS;
							continue;
						}
						// check for "Errors"
						if (lstrcmpi( cfgParser[i], "Errors" ) == 0) {
							// check if prevously set
							if ((g_vars.m_nWarnSysopByMail & WARN_SYSOP_ABOUT_ERRORS) != 0) {
								cfgParser.LogError( TEXT("Duplicate error") );
								m_iErrorCode = ERROR_DUPLICATE;
								break;
							}
							g_vars.m_nWarnSysopByMail |= WARN_SYSOP_ABOUT_ERRORS;
							continue;
						}
						// unknown parameter
						cfgParser.LogError( TEXT("Unknown parameter") );
						m_iErrorCode = ERROR_SYNTAX;
						break;
					}
				}
				break;
			/***********************
			  WarningInsteadOfError
			 ***********************/
			case CFG_LEXEM_WARNING_INSTEAD_OF_ERROR:
				{
					RESET_FLAGS;
					// check number or arguments
					if (cfgParser.Count() != 2) {
						g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
						m_iErrorCode = ERROR_NUMBER;
						break;
					}
					switch (getWELexemID(cfgParser[1])) {
					case WE_LEXEM_INCORRECT_CRC32:
						if (g_warnings.m_flagIncorrectCRC32.Defined()) {
                            				g_vars.m_log << TEXT("Error in file ") << vCfgFiles.back().m_szName << TEXT(" at line ") << nLine << TEXT("\n");
							g_vars.m_log << TEXT("Already defined parameter\n");
                            				m_iErrorCode = ERROR_DUPLICATE;
						}
						else
							g_warnings.m_flagIncorrectCRC32 = true;
						break;
					default:
						g_vars.m_log << TEXT("Error in file ") << vCfgFiles.back().m_szName << TEXT(" at line ") << nLine << TEXT("\n");
						m_iErrorCode = ERROR_UNKNOWN_KEYWORD;
						break;
					}
				}
				break;
			/**************
			  NoMailNotify
			 **************/
			case CFG_LEXEM_NO_MAIL_NOTIFY:
				{
					RESET_FLAGS;
					// check number or arguments
					if (cfgParser.Count() != 2) {
						g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
						m_iErrorCode = ERROR_NUMBER;
						break;
					}
					if (lstrcmpi( cfgParser[1], TEXT("basepurge") ) != 0) {
						g_vars.m_log << TEXT("Error in file ") << vCfgFiles.back().m_szName << TEXT(" at line ") << nLine << TEXT("\n");
						m_iErrorCode = ERROR_UNKNOWN_KEYWORD;
						break;
					}
					if (g_vars.m_nNoMailNotify != 0) {
						cfgParser.LogError( TEXT("Duplicate error") );
						m_iErrorCode = ERROR_DUPLICATE;
						break;
					}
					g_vars.m_nNoMailNotify = 1;
				}
				break;
			/*******************
			  ReplyMessageAttrs
			 *******************/
			case CFG_LEXEM_REPLY_MESSAGE_ATTRS:
				{
					RESET_FLAGS;
					// check number or arguments
					if (cfgParser.Count() == 1) {
						g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\n");
						m_iErrorCode = ERROR_NUMBER;
						break;
					}
					// check duplicates
					if (g_vars.m_nReplyMessageAttrs != 0 ||
					    g_vars.m_nReplyMessageFlags != 0)
					{
                            			g_vars.m_log << TEXT("Error in file ") << vCfgFiles.back().m_szName << TEXT(" at line ") << nLine << TEXT("\n");
						g_vars.m_log << TEXT("Already defined parameter\n");
                            			m_iErrorCode = ERROR_DUPLICATE;
					}
					uint16	nAttr;
					uint16	nFlag;
					for (i = 1; i < cfgParser.Count(); i++) {
						if (!GetAttrOrFlag( cfgParser[i], nAttr, nFlag )) {
							// unknown attribute
							g_vars.m_log << TEXT("Syntax error in file ") << vCfgFiles.back().m_szName << TEXT(" at line ") << nLine << TEXT("\n");
							g_vars.m_log << TEXT("Unknown attribute ") << i << TEXT_EOL;
							m_iErrorCode = ERROR_SYNTAX;
							break;
						}
						// check for duplicates
						if ((g_vars.m_nReplyMessageAttrs & nAttr) != 0 ||
						    (g_vars.m_nReplyMessageFlags & nFlag) != 0) {
                            				g_vars.m_log << TEXT("Error in file ") << vCfgFiles.back().m_szName << TEXT(" at line ") << nLine << TEXT("\n");
							g_vars.m_log << TEXT("Duplicate attribute\n");
                            				m_iErrorCode = ERROR_DUPLICATE;
							break;
						}
						// keep attributes
						g_vars.m_nReplyMessageAttrs |= nAttr;
						g_vars.m_nReplyMessageFlags |= nFlag;
					}
				}
				break;
                        /*********
                          Include
                         *********/
                        case CFG_LEXEM_INCLUDE: {
                            RESET_FLAGS;
                            lstrcpy( szFileName, cfgParser[1] );
                            if (szFileName[0] == _T('"'))
                                RemoveBoundaryQuotes( szFileName );
                            // check if full name or not
                            if (szFileName[0] != _T('\0') && szFileName[1] == _T(':'))
                                lstrcpy( szAppCfgFullName, szFileName );
                            else {
                                lstrcpy( szAppCfgFullName, m_szStartupPath );
                                lstrcat( szAppCfgFullName, szFileName );
                            }
                            // check if we already have this config
			    vector<SCfgFile>::iterator	it;
			    for (it = vCfgFiles.begin(); it != vCfgFiles.end(); it++) {
                                if (lstrcmpi( (*it).m_szName, szAppCfgFullName ) == 0)
                                    break;
                            }
                            if (it == vCfgFiles.end()) {
				    vCfgFiles.back().m_iSkipLines = cfgParser.GetLine();
				    SCfgFile	cfgFile;
				    lstrcpy( cfgFile.m_szName, szAppCfgFullName );
				    cfgFile.m_iSkipLines = 0;
				    vCfgFiles.push_back( cfgFile );
				    fIncludeFound = true;
				    break;
                            }
                            break;
                        }
                        default: {
                            g_vars.m_log << _T("Error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                            m_iErrorCode = ERROR_UNKNOWN_KEYWORD;
                            break;
                        }
                    }
                }
                else if (!cfgParser.Eof()) {
                    nLine++;
                    g_vars.m_log << _T("Syntax error in file ") << vCfgFiles.back().m_szName << _T(" at line ") << nLine << _T("\r\n");
                    m_iErrorCode = ERROR_SYNTAX;
                    break;
                }
            }
            
        }
        else {
            g_vars.m_log << _T("Configuration file not found: ") << vCfgFiles.back().m_szName << _T("\r\n");
            m_iErrorCode = ERROR_FILE_ABSENT;
        }
        if (m_iErrorCode == ERROR_NONE && fIncludeFound == false) {
            // go back one list item
            vCfgFiles.pop_back();
        }
    }
    
	if (m_iErrorCode != ERROR_NONE)
		return;

	if (g_vars.m_addrMain.Domain[0] == _T('\0')) {
		g_vars.m_log << _T("Error: system address wasn't defined in file ") << szAppCfgName << _T("\r\n");
		m_iErrorCode = ERROR_ABSENT_DEF;
		return;
	}
	if (g_vars.m_szInboundPath[0] == _T('\0')) {
		g_vars.m_log << _T("Error: Inbound path wasn't defined in file ") << szAppCfgName << _T("\r\n");
		m_iErrorCode = ERROR_ABSENT_DEF;
		return;
	}
	if (g_vars.m_szBinkOutboundPath[0] == _T('\0')) {
		g_vars.m_log << _T("Error: BinkOutbound path wasn't defined in file ") << szAppCfgName << _T("\r\n");
		m_iErrorCode = ERROR_ABSENT_DEF;
		return;
	}
	if (g_vars.m_szNetmailPath[0] == _T('\0')) {
		g_vars.m_log << _T("Error: Netmail path wasn't defined in file ") << szAppCfgName << _T("\r\n");
		m_iErrorCode = ERROR_ABSENT_DEF;
		return;
	}

	if (g_vars.m_szBadTicsPath[0] == _T('\0')) {
		g_vars.m_log << _T("Error: BadTics path wasn't defined in file ") << szAppCfgName << TEXT_EOL;
		m_iErrorCode = ERROR_ABSENT_DEF;
		return;
	}
	if (g_vars.m_szNewTicsPath[0] == _T('\0')) {
		g_vars.m_log << _T("Error: NewTics path wasn't defined in file ") << szAppCfgName << TEXT_EOL;
		m_iErrorCode = ERROR_ABSENT_DEF;
		return;
	}
	// we don't check OldTics because we allow them to not be defined
	// in this case we'll remove tics

	if (g_vars.m_vsAliases.empty())
		g_vars.m_vsAliases.push_back( _T("Adrenalin") );

	// set defaults for

	// AutoCreatedPath
	if (g_vars.m_szAutoCreatedPath[0] == _T('\0'))
		lstrcpy( g_vars.m_szAutoCreatedPath, m_szStartupPath );

	// LongPaths
	if (!g_vars.m_fLongPaths.Defined())
		g_vars.m_fLongPaths = true;

	// HandleReplaces
	if (!g_vars.m_fHandleReplaces.Defined())
		g_vars.m_fHandleReplaces = false;

	// AllAKASeen
	if (!g_vars.m_fAllAKASeen.Defined())
		g_vars.m_fAllAKASeen = false;

	// KillProcessedMail
	if (!g_vars.m_fKillProcessedMail.Defined())
		g_vars.m_fKillProcessedMail = false;

	// ShowMustGoOn
	if (!g_vars.m_fShowMustGoOn.Defined())
		g_vars.m_fShowMustGoOn = true;

	// LogMsgNames
	if (!g_vars.m_fLogMsgNames.Defined())
		g_vars.m_fLogMsgNames = false;

	// HatchOriginMain
	if (!g_vars.m_fHatchOriginMain.Defined())
		g_vars.m_fHatchOriginMain = false;

	// ConcatDescriptions
	if (!g_vars.m_flagConcatDescriptions.Defined())
		g_vars.m_flagConcatDescriptions = false;

	// LongDescPrefix
	if (g_vars.m_szLongDescPrefix[0] == _T('\0'))
		lstrcpy( g_vars.m_szLongDescPrefix, _T(" ") );

	// Filelist
	if (g_vars.m_szFilelistFileName[0] == TEXT('\0')) {
		lstrcpy( g_vars.m_szFilelistFileName, TEXT("files.bbs") );
	}

	// FileListFormat
	if (g_vars.m_fileListFormat.getFormat().length() <= 0) {
		g_vars.m_fileListFormat.setFormat( TEXT("%12n %d") );
	}

	// message attributes (by default we use flag of zero)
	if (g_vars.m_nReplyMessageAttrs == 0) {
		g_vars.m_nReplyMessageAttrs = ATTR_PRIVATE | ATTR_LOCAL;
	}


	// warnings


	// IncorrectCRC32
	if (!g_warnings.m_flagIncorrectCRC32.Defined())
		g_warnings.m_flagIncorrectCRC32 = false;


	// choose AKA addresses for links

	// TODO: what to do with this remarked code below??? Help!!!
	/*
	m_links.SelectFirst();
	if (m_links.IsSelected()) {
		do {
			if (m_links.GetSelected().getOurAddress() == NULL)
				ChooseAKA( m_links.GetSelected() );
		} while (m_links.SelectNext());
	}
	*/

	// LngFile
	if (*m_szLngFileName == _T('\0')) {
		lstrcpy( m_szLngFileName, m_szStartupPath );
		lstrcat( m_szLngFileName, _T("Adrenalin.lng") );
	}

    // prepare requests log directory if this log file name defined
    if (!IsEmptyStr(requestsLogFileName)) {
		// get dir from name
		for (i = 0, j = -1; requestsLogFileName[i] != TEXT('\0'); i++) {
			if (requestsLogFileName[i] == PATH_SEPARATOR)
				j = i;
		}
		if (j >= 0) {
			requestsLogFileName[j] = TEXT('\0');
			MakeDirStructure( requestsLogFileName );
            requestsLogFileName[j] = PATH_SEPARATOR;
		}
    }

	// init Log
	if (*szLogFileName == _T('\0')) {
		lstrcpy( szLogFileName, m_szStartupPath );
		lstrcat( szLogFileName, _T("adrenalin.log") );
	}
	else {
		// get dir from name
		for (i = 0, j = -1; szLogFileName[i] != _T('\0'); i++) {
			if (szLogFileName[i] == _T('\\'))
				j = i;
		}
		if (j >= 0) {
			szLogFileName[j] = _T('\0');
			MakeDirStructure( szLogFileName );
			szLogFileName[j] = _T('\\');
		}
	}
	if (!g_vars.m_log.Open( szLogFileName )) {
		g_vars.m_log << TEXT("Failed to open log file ") << szLogFileName << TEXT_EOL;
	}
	else {
		// print start time only in log

		TCHAR	buffer[128];
		formatLogTime( startTime, buffer );

		g_vars.m_log << CLog::SetSingle(new CLog::FileOut())
			     << TEXT("Start: ") << buffer << TEXT_EOL 
			     << CLog::Pop();
	}
}
